package ru.yandex.tours.partners.leveltravel

import org.json.JSONObject
import ru.yandex.tours.model.RequestStatus.RequestStatus
import ru.yandex.tours.model.{RequestStatus, TourOperator}
import ru.yandex.tours.operators.TourOperators

import scala.collection.JavaConverters._
import scala.util.Try

/* @author berkut@yandex-team.ru */

object EnqueueResponse {

  private def getStatus(string: String) = {
    val upperCase = string.toUpperCase
    RequestStatus.values.find(_.toString == upperCase)
      .getOrElse(RequestStatus.UNKNOWN)
  }

  def parse(json: String, tourOperators: TourOperators,
            optRequestId: Option[String] = None): Try[EnqueueResponse] = Try {
    val x = new JSONObject(json)
    val requestId = optRequestId.getOrElse(x.getString("request_id"))
    val status = x.getJSONObject("status")
    val operators = status.keys().asScala.map(key =>
      key.toString -> getStatus(status.getString(key.toString))
    ).flatMap({case (operatorId, st) =>
      tourOperators.getByCode(partner, operatorId).map(_ -> st)
    }).toMap
    EnqueueResponse(requestId, operators)
  }
}

case class EnqueueResponse(requestId: String, operators: Map[TourOperator, RequestStatus]) {
  require(operators.nonEmpty, "Response should contains at least 1 operator")

  def isFinished(operator: TourOperator): Boolean = operators.get(operator).exists(RequestStatus.isFinished)
}