package ru.yandex.tours.partners.leveltravel

import akka.util.Timeout
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.partners.InstrumentedPartnerClient
import spray.http.StatusCode

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 27.03.15
 */
trait InstrumentedLtClient extends DefaultLtClient with InstrumentedPartnerClient {
  override protected def fetch(url: String, requestName: String)
                              (implicit timeout: Timeout): Future[(StatusCode, String)] = {
    wrap(Partners.lt, requestName, super.fetch(url: String, requestName))
  }
}
