package ru.yandex.tours.partners.leveltravel

import ru.yandex.tours.model.TourOperator
import ru.yandex.tours.model.search.SearchProducts.{Actualization, HotelSnippet, Offer}
import ru.yandex.tours.model.search.{ExtendedHotelSearchRequest, HotelSearchRequest, OfferSearchRequest}

import scala.concurrent.Future

trait LtClient {
  def enqueue(request: ExtendedHotelSearchRequest, hotelId: Option[String] = None): Future[EnqueueResponse]

  def status(requestId: String): Future[EnqueueResponse]

  def snippets(requestId: String,
               operators: Iterable[TourOperator],
               request: HotelSearchRequest): Future[Iterable[HotelSnippet]]

  def tours(requestId: String, hotelId: String,
            operators: Iterable[TourOperator],
            request: OfferSearchRequest): Future[Iterable[Offer]]

  def actualization(requestId: String, tourId: String): Future[Option[Actualization]]
}
