package ru.yandex.tours.partners.leveltravel

import ru.yandex.tours.model.TourOperator
import ru.yandex.tours.model.search.SearchProducts.{Actualization, HotelSnippet, Offer}
import ru.yandex.tours.model.search.{ExtendedHotelSearchRequest, HotelSearchRequest, OfferSearchRequest}
import ru.yandex.tours.util.Throttler

import scala.concurrent.{ExecutionContext, Future}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 27.03.15
 */
class ThrottledLtClient(client: LtClient, throttler: Throttler)(implicit ec: ExecutionContext) extends LtClient {
  private val id = "level.travel"

  override def enqueue(request: ExtendedHotelSearchRequest, hotelId: Option[String]): Future[EnqueueResponse] = {
    throttler.throttle("enqueue", id) {
      client.enqueue(request, hotelId)
    }
  }

  override def status(requestId: String): Future[EnqueueResponse] = {
    throttler.throttle("status", id) {
      client.status(requestId)
    }
  }

  override def snippets(requestId: String,
                        operators: Iterable[TourOperator],
                        request: HotelSearchRequest): Future[Iterable[HotelSnippet]] = {
    throttler.throttle("results", id) {
      client.snippets(requestId, operators, request)
    }
  }

  override def tours(requestId: String, hotelId: String, operators: Iterable[TourOperator],
                     request: OfferSearchRequest): Future[Iterable[Offer]] = {
    throttler.throttle("results", id) {
      client.tours(requestId, hotelId, operators, request)
    }
  }

  override def actualization(requestId: String, tourId: String): Future[Option[Actualization]] = {
    throttler.throttle("results", id) {
      client.actualization(requestId, tourId)
    }
  }
}
