package ru.yandex.tours.partners.leveltravel.downloader

import ru.yandex.tours.model.TourOperator
import ru.yandex.tours.model.search.HotelSearchRequest
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Source}
import ru.yandex.tours.partners.PartnerProtocol.{SnippetsResult, Results}
import ru.yandex.tours.partners.leveltravel.LtClient
import ru.yandex.tours.partners.leveltravel.downloader.AbstractDownloader.DownloadRequest

import scala.concurrent.Future

/* @author berkut@yandex-team.ru */


class HotelDownloader(client: LtClient,
                      downloadRequest: DownloadRequest,
                      searchRequest: HotelSearchRequest)
  extends AbstractDownloader[HotelSnippet, HotelSearchRequest, SnippetsResult](client, downloadRequest, searchRequest) {

  override protected def getSource(s: HotelSnippet): Source = s.getSource(0)

  override protected def fetchSnippets(requestId: String,
                                       successOperators: Iterable[TourOperator]): Future[Iterable[HotelSnippet]] = {
    client.snippets(requestId, successOperators, searchRequest)
  }

  override protected def createResponse(operator: TourOperator, result: Results[HotelSnippet]): SnippetsResult = {
    SnippetsResult(operator, result)
  }
}
