package ru.yandex.tours.partners.leveltravel.downloader

import ru.yandex.tours.model.TourOperator
import ru.yandex.tours.model.search.OfferSearchRequest
import ru.yandex.tours.model.search.SearchProducts.{Offer, Source}
import ru.yandex.tours.partners.PartnerProtocol.{Results, OffersResult}
import ru.yandex.tours.partners.leveltravel.LtClient
import ru.yandex.tours.partners.leveltravel.downloader.AbstractDownloader.DownloadRequest

import scala.concurrent.Future

class TourDownloader(client: LtClient, checkStatus: DownloadRequest, hotelId: String, searchRequest: OfferSearchRequest, lowPriority: Boolean)
  extends AbstractDownloader[Offer, OfferSearchRequest, OffersResult](client, checkStatus, searchRequest) {
  override protected def getSource(s: Offer): Source = s.getSource

  override protected def fetchSnippets(requestId: String, successOperators: Iterable[TourOperator]): Future[Iterable[Offer]] = {
    client.tours(requestId, hotelId, successOperators, searchRequest)
  }

  override protected def createResponse(operator: TourOperator, results: Results[Offer]): OffersResult = {
    OffersResult(operator, results, if (lowPriority) 1 else 0)
  }
}
