package ru.yandex.tours.partners.ostrovokv3

import ru.yandex.tours.model.HotelProvider
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.model.search.{ExtendedHotelSearchRequest, ExtendedOfferSearchRequest}
import ru.yandex.tours.partners.HotelProviderClient

import scala.concurrent.{ExecutionContext, Future}

trait OstrovokV3Client extends HotelProviderClient {
  implicit def ec: ExecutionContext

  def searchRates(hotelSearchRequest: ExtendedHotelSearchRequest, provider: HotelProvider): Future[OstrovokV3Response]

  def searchRates(offerSearchRequest: ExtendedOfferSearchRequest, provider: HotelProvider): Future[OstrovokV3Response]

  override final def searchHotels(request: ExtendedHotelSearchRequest,
                                  provider: HotelProvider): Future[Iterable[HotelSnippet]] = {
    searchRates(request, provider).map {
      response => offersToSnippets(response.offers)
    }
  }

  override final def searchOffers(request: ExtendedOfferSearchRequest,
                                  provider: HotelProvider): Future[Iterable[Offer]] = {
    searchRates(request, provider).map(_.offers)
  }
}
