package ru.yandex.tours.partners.sunmar

import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.partners.InstrumentedPartnerClient

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 04.08.15
 */
trait InstrumentedSunmarClient extends DefaultSunmarClient with InstrumentedPartnerClient {
  override def packages(request: PackageListRequest): Future[Seq[ProductList]] = wrap(Partners.sunmar, "packages", super.packages(request))

  override def actualize(productList: ProductList): Future[Seq[ProductListDayDetail]] = wrap(Partners.sunmar, "actualize", super.actualize(productList))
}
