package ru.yandex.tours.partners.sunmar

import ru.yandex.tours.util.Throttler

import scala.concurrent.{ExecutionContext, Future}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 04.08.15
 */
class ThrottledSunmarClient(client: SunmarClient, throttler: Throttler)
                           (implicit ec: ExecutionContext) extends SunmarClient {

  private val id = "sunmar"

  override def packages(request: PackageListRequest): Future[Seq[ProductList]] = {
    throttler.throttle("enqueue", id) {
      client.packages(request)
    }
  }

  override def actualize(productList: ProductList): Future[Seq[ProductListDayDetail]] = {
    throttler.throttle("results", id) {
      client.actualize(productList)
    }
  }
}
