package ru.yandex.tours.searcher.api

import akka.actor.ActorRef
import ru.yandex.tours.services.{FlightSearchService, RemoteFlightSearchService, RemoteTransferSearchService, TransferSearchService}
import ru.yandex.tours.util.spray.{HttpHandler, RouteesContext, SearchDirectives}
import ru.yandex.tours.util.zoo.SharedValue
import spray.routing.Route

class RootSearcherHttpHandler(routeesContext: RouteesContext,
                              toursHandler: ActorRef,
                              roomsHandler: ActorRef,
                              flightSearchService: FlightSearchService,
                              transferSearchService: TransferSearchService,
                              enableWrites: SharedValue[Boolean])
  extends HttpHandler with SearchDirectives {

  override def route: Route = pathPrefix("api" / "1.x") {
    pathPrefix("rooms") {
      ctx => roomsHandler ! ctx
    } ~ pathPrefix("tours") {
      ctx => toursHandler ! ctx
    } ~ pathPrefixTest("flights") {
      RemoteFlightSearchService.routes(flightSearchService, routeesContext)
    } ~ pathPrefixTest(RemoteTransferSearchService.routePrefix) {
      RemoteTransferSearchService.routes(transferSearchService, routeesContext)
    } ~ (path("chwrites") & post & parameter("enable".as[Boolean])) { enable =>
      enableWrites.set(enable)
      val msg = if (enable) "Enabled writing to clickhouse" else "Disabled writing to clickhouse"
      log.info(msg)
      complete(msg)
    } ~ {
      ctx => toursHandler ! ctx
    }
  }
}
