package ru.yandex.tours.util

import java.util.logging.{LogRecord, Level, Logger}

import org.apache.cxf.Bus
import org.apache.cxf.feature.AbstractFeature
import org.apache.cxf.interceptor.{InterceptorProvider, LoggingInInterceptor, LoggingOutInterceptor}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 12.10.15
 */
class LoggingFeature(limit: Int, pretty: Boolean, showBinary: Boolean) extends AbstractFeature {
  protected override def initializeProvider(provider: InterceptorProvider, bus: Bus) {
    val in: LoggingInInterceptor = new LoggingInInterceptor(limit) {
      override def log(logger: Logger, message: String): Unit = {
        if (logger.isLoggable(Level.FINE)) {
          val lr: LogRecord = new LogRecord(Level.FINE, message)
          lr.setSourceClassName(logger.getName)
          lr.setSourceMethodName(null)
          lr.setLoggerName(logger.getName)
          logger.log(lr)
        }
      }
    }
    in.setOutputLocation(null)
    in.setPrettyLogging(pretty)
    in.setShowBinaryContent(showBinary)
    val out: LoggingOutInterceptor = new LoggingOutInterceptor(limit) {
      override def log(logger: Logger, message: String): Unit = {
        if (logger.isLoggable(Level.FINE)) {
          val lr: LogRecord = new LogRecord(Level.FINE, message)
          lr.setSourceClassName(logger.getName)
          lr.setSourceMethodName(null)
          lr.setLoggerName(logger.getName)
          logger.log(lr)
        }
      }
    }
    out.setOutputLocation(null)
    out.setPrettyLogging(pretty)
    out.setShowBinaryContent(showBinary)
    provider.getInInterceptors.add(in)
    provider.getInFaultInterceptors.add(in)
    provider.getOutInterceptors.add(out)
    provider.getOutFaultInterceptors.add(out)
  }
}
