package ru.yandex.tours.util

import java.io.ByteArrayInputStream
import javax.xml.bind.JAXBContext

import org.apache.commons.io.output.ByteArrayOutputStream
import org.apache.cxf.transports.http.configuration.ProxyServerType

import scala.concurrent.duration.FiniteDuration

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 14.08.15
 */
trait WsdlUtils {
  import org.apache.cxf.frontend.ClientProxy
  import org.apache.cxf.transport.http.HTTPConduit

  def injectProxy(searchService: Object, host: String, port: Int): Unit = {
    val client = ClientProxy.getClient(searchService)
    val http = client.getConduit.asInstanceOf[HTTPConduit]
    http.getClient.setProxyServer(host)
    http.getClient.setProxyServerPort(port)
    http.getClient.setProxyServerType(ProxyServerType.HTTP)
  }

  def injectTimeouts(searchService: Object, connectTimeout: FiniteDuration, receiveTimeout: FiniteDuration): Unit = {
    val client = ClientProxy.getClient(searchService)
    val http = client.getConduit.asInstanceOf[HTTPConduit]
    http.getClient.setConnectionTimeout(connectTimeout.toMillis)
    http.getClient.setReceiveTimeout(receiveTimeout.toMillis)
  }

  private lazy val context = JAXBContext.newInstance("ru.yandex.tours.partners.sunmar")

  def marshal(obj: AnyRef): Array[Byte] = {
    IO.using(new ByteArrayOutputStream()) { out =>
      context.createMarshaller().marshal(obj, out)
      out.toByteArray
    }
  }

  def unmarshal[T](bytes: Array[Byte]): T = {
    context.createUnmarshaller()
      .unmarshal(new ByteArrayInputStream(bytes))
      .asInstanceOf[T]
  }
  
}

object WsdlUtils extends WsdlUtils
