#!/bin/sh

. ./component.sh

JAVA_HOME=/usr/local/java8
PATH="$JAVA_HOME/bin:$PATH"

LANG=ru_RU.UTF8
PID_FILE=${DAEMON}.pid
HPROF_DIR=hprof/$DAEMON
LIB_PATH=lib

LOG_DIR="logs"
LOG_FILE="${LOG_DIR}/${DAEMON}.log"
STDOUT_LOG_FILE="${LOG_DIR}/${DAEMON}.log.shell"
GC_LOG="${LOG_DIR}/${DAEMON}-gc.log"
mkdir -p "${LOG_DIR}"

CLASSPATH=`find $LIB_PATH -name '*.jar' -printf '%p:'`$CLASSPATH
echo "classpath: $CLASSPATH" >> "${STDOUT_LOG_FILE}"

export PATH LANG JAVA_HOME CLASSPATH
#-agentpath:./libyjpagent.so \

java -classpath $CLASSPATH  \
     -Dfile.encoding=UTF8 \
     -showversion -server -Xverify:none \
     -Xmx3g -Xms3g \
     -XX:+UseParallelGC \
     -XX:+UseParallelOldGC \
     -XX:+UseTLAB \
     -XX:+UseNUMA \
     -XX:+HeapDumpOnOutOfMemoryError \
     -XX:HeapDumpPath=${HPROF_DIR} \
     -XX:OnOutOfMemoryError="echo on oom killing process %p; kill -9 %p" \
     -Xloggc:${GC_LOG} \
     -XX:+PrintCommandLineFlags \
     -XX:+PrintGCApplicationStoppedTime \
     -XX:+PrintGCDetails \
     -XX:+PrintGCDateStamps \
     -XX:+PrintGCCause \
     -XX:+PrintPromotionFailure \
     -XX:+PrintGCApplicationStoppedTime \
     -Dhost.name=`/bin/hostname --fqdn` \
     -Dsun.net.client.defaultConnectTimeout=10000 \
     -Dsun.net.client.defaultReadTimeout=10000 \
     -Dsun.net.inetaddr.ttl=86400 -Dhttp.keepAlive=false \
     -Dlogging.path=$LOG_DIR \
     ru.yandex.tours.spark.TestApp >> "${STDOUT_LOG_FILE}" 2>&1 &

echo $! > $PID_FILE