package ru.yandex.tours.spark

import com.esotericsoftware.kryo.Kryo
import com.google.protobuf.MessageLite
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer
import de.javakaffee.kryoserializers.jodatime.{JodaDateTimeSerializer, JodaLocalDateSerializer, JodaLocalDateTimeSerializer}
import de.javakaffee.kryoserializers.protobuf.ProtobufSerializer
import org.apache.spark.serializer.KryoRegistrator
import org.joda.time.{DateTime, LocalDate, LocalDateTime}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 29.12.15
 */
class MySerialization extends KryoRegistrator {
  override def registerClasses(kryo: Kryo): Unit = {
    kryo.register(classOf[DateTime], new JodaDateTimeSerializer())
    kryo.register(classOf[LocalDate], new JodaLocalDateSerializer())
    kryo.register(classOf[LocalDateTime], new JodaLocalDateTimeSerializer())

    UnmodifiableCollectionsSerializer.registerSerializers(kryo)

    kryo.addDefaultSerializer(classOf[MessageLite], new ProtobufSerializer)
  }
}