package ru.yandex.tours.storage

import ru.yandex.tours.model.search.SearchResults.{Context, HotelSearchResult, OfferSearchResult}
import ru.yandex.tours.model.search.{HotelSearchRequest, OfferSearchRequest}

import scala.concurrent.{ExecutionContextExecutor, Future}
import scala.util.Try


abstract class ByteArrayDao(implicit ec: ExecutionContextExecutor) extends ToursDao {
  def getContextBytes(request: HotelSearchRequest): Future[Array[Byte]]

  def getHotelSearchResultBytes(request: HotelSearchRequest): Future[Option[Array[Byte]]]

  def getOffersSearchResultBytes(request: OfferSearchRequest): Future[Option[Array[Byte]]]

  def getOffersSearchResultsBytes(request: HotelSearchRequest, hotelIds: Iterable[Int]): Future[Seq[Array[Byte]]]

  def saveHotelSearchResult(request: HotelSearchRequest, response: HotelSearchResult): Future[Unit]

  def saveOffersSearchResult(request: OfferSearchRequest, response: OfferSearchResult): Future[Unit]

  def saveContext(request: HotelSearchRequest, context: Context): Future[Unit]

  protected val DEFAULT_CONTEXT = Context.getDefaultInstance

  def getContext(request: HotelSearchRequest): Future[Context] = {
    for (rs <- getContextBytes(request)) yield {
      rs match {
        case null =>
          DEFAULT_CONTEXT
        case bytes =>
          Try{Context.parseFrom(bytes)}.toOption.getOrElse(DEFAULT_CONTEXT)
      }
    }
  }

  def getHotelSearchResult(request: HotelSearchRequest): Future[Option[HotelSearchResult]] = {
    for (optionBytes <- getHotelSearchResultBytes(request)) yield {
        for (bytes <- optionBytes) yield HotelSearchResult.parseFrom(bytes)
    }
  }


  def getOffersSearchResult(request: OfferSearchRequest): Future[Option[OfferSearchResult]] = {
    for (optionBytes <- getOffersSearchResultBytes(request)) yield {
      for (bytes <- optionBytes) yield OfferSearchResult.parseFrom(bytes)
    }
  }

  def getOffersSearchResults(request: HotelSearchRequest,
                             hotelIds: Iterable[Int]): Future[Seq[OfferSearchResult]] = {
    for (arrList <- getOffersSearchResultsBytes(request, hotelIds)) yield {
      for {
        bytes <- arrList.seq
      } yield OfferSearchResult.parseFrom(bytes)
    }
  }
}
