package ru.yandex.tours.storage

import java.util.concurrent.ConcurrentHashMap

import ru.yandex.tours.model.search.SearchResults.{Context, HotelSearchResult, OfferSearchResult}
import ru.yandex.tours.model.search.{HotelSearchRequest, OfferSearchRequest}

import scala.concurrent.Future

class MockToursDao extends ToursDao {
  private val contexts = new ConcurrentHashMap[HotelSearchRequest, Context]()
  private val hotelResults = new ConcurrentHashMap[HotelSearchRequest, HotelSearchResult]()
  private val tourResults = new ConcurrentHashMap[OfferSearchRequest, OfferSearchResult]()

  override def saveContext(request: HotelSearchRequest, context: Context): Future[Unit] = Future.successful {
    contexts.put(request, context)
  }

  override def getOffersSearchResult(request: OfferSearchRequest): Future[Option[OfferSearchResult]] = Future.successful {
    Option(tourResults.get(request))
  }

  override def getHotelSearchResult(request: HotelSearchRequest): Future[Option[HotelSearchResult]] = Future.successful {
    Option(hotelResults.get(request))
  }

  override def getContext(request: HotelSearchRequest): Future[Context] = Future.successful {
    contexts.getOrDefault(request, Context.newBuilder().build())
  }

  override def saveHotelSearchResult(request: HotelSearchRequest, response: HotelSearchResult): Future[Unit] = Future.successful {
    hotelResults.put(request, response)
  }

  override def saveOffersSearchResult(request: OfferSearchRequest, response: OfferSearchResult): Future[Unit] = Future.successful {
    tourResults.put(request, response)
  }

  override def getOffersSearchResults(request: HotelSearchRequest, hotelIds: Iterable[Int]): Future[Seq[OfferSearchResult]] = {
    Future.successful {
      hotelIds.flatMap { hotelId =>
        val req = OfferSearchRequest(request, hotelId)
        Option(tourResults.get(req))
      }.toSeq
    }
  }
}
