package ru.yandex.tours.storage

import ru.yandex.tours.model.search.{HotelSearchRequest, OfferSearchRequest}
import ru.yandex.tours.model.search.SearchResults.{Context, HotelSearchResult, OfferSearchResult}

import scala.concurrent.Future

/* @author berkut@yandex-team.ru */

trait ToursDao {
  def saveContext(request: HotelSearchRequest, context: Context): Future[Unit]

  def getContext(request: HotelSearchRequest): Future[Context]

  def saveHotelSearchResult(request: HotelSearchRequest, response: HotelSearchResult): Future[Unit]

  def getHotelSearchResult(request: HotelSearchRequest): Future[Option[HotelSearchResult]]

  def saveOffersSearchResult(request: OfferSearchRequest, response: OfferSearchResult): Future[Unit]

  def getOffersSearchResult(request: OfferSearchRequest): Future[Option[OfferSearchResult]]

  def getOffersSearchResults(request: HotelSearchRequest, hotelIds: Iterable[Int]): Future[Seq[OfferSearchResult]]
}