package ru.yandex.tours.storage.direction

import java.time.Month

import ru.yandex.tours.model.Prices.DirectionBestPrice

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 10.07.15
 */
case class DirectionMonthBestPrice(geoId: Int,
                                   month: Month,
                                   prices: Seq[DirectionBestPrice],
                                   created: Long = System.currentTimeMillis()) {

  val priceByNight = prices.groupBy(_.getSearchRequest.getNights).mapValues(_.head)

  require(priceByNight.size == prices.size, "not unique nights in prices")
}
