package ru.yandex.tours.storage.direction

import java.time.Month

import ru.yandex.tours.util.Logging

import scala.concurrent.{ExecutionContext, Future}

class DirectionPriceTwinDao(primary: DirectionPriceDao, secondary: DirectionPriceDao, sync: Boolean)
                           (implicit ec: ExecutionContext) extends DirectionPriceDao with Logging {
  override def update(from: Int, ages: Seq[Int], month: Month, geoId: Int,
                      entity: DirectionMonthBestPrice): Future[Unit] = {
    val p = primary.update(from, ages, month, geoId, entity)
    val s = secondary.update(from, ages, month, geoId, entity).recover({
      case e =>
        log.error("Error in Secondary Storage", e)})
    val ss = if (sync) s else Future.successful(())
    for {
      prim <- p
      _ <- ss
    } yield prim
  }

  override def get(from: Int, ages: Seq[Int], geoId: Int, months: Set[Month]): Future[Seq[DirectionMonthBestPrice]] = {
    val p = primary.get(from, ages, geoId, months)
    val s = secondary.get(from, ages, geoId, months).recoverWith({
      case e =>
        log.error("Error in Secondary Storage", e)
        Future.successful(Seq.empty)})
    val ss = if (sync) s else Future.successful(Seq.empty)
    for {
      prim <- p
      _ <- ss
    } yield prim
  }
}
