package ru.yandex.tours.storage.flight

import ru.yandex.tours.model.search.{FlightSearchRequest, SearchResults}
import ru.yandex.tours.util.Logging

import scala.concurrent.{ExecutionContext, Future}

class FlightsTwinDao(primary: FlightsDao, secondary: FlightsDao, sync: Boolean)
                    (implicit ec: ExecutionContext) extends FlightsDao with Logging{
  override def saveFlights(request: FlightSearchRequest, flights: SearchResults.FlightSearchResult): Future[Unit] = {
    val p = primary.saveFlights(request, flights)
    val s = secondary.saveFlights(request, flights).recover({
      case e =>
        log.error("Error in Secondary Storage", e)})
    val ss = if (sync) s else Future.successful(())
    for {
      prim <- p
      _ <- ss
    } yield prim
  }

  override def getFlights(request: FlightSearchRequest): Future[Option[SearchResults.FlightSearchResult]] = {
    val p = primary.getFlights(request)
    val s = secondary.getFlights(request).recoverWith({
      case e =>
        log.error("Error in Secondary Storage", e)
        Future.successful(Option.empty)})
    val ss = if (sync) s else Future.successful(Option.empty)
    for {
      prim <- p
      _ <- ss
    } yield prim
  }
}
