package ru.yandex.tours.storage.flight

import ru.yandex.tours.model.search.FlightSearchRequest
import ru.yandex.tours.model.search.SearchResults.FlightSearchResult
import ru.yandex.tours.services.CalendarPushService

import scala.concurrent.{ExecutionContext, Future}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 28.03.16
 */
class ProxyFlightsDao(dao: FlightsDao, calendarPushService: CalendarPushService)
                     (implicit ec: ExecutionContext) extends FlightsDao {
  override def saveFlights(request: FlightSearchRequest, flights: FlightSearchResult): Future[Unit] = {
    val push = if (flights.getProgress.getIsFinished) {
      calendarPushService.saveFlights(request, flights)
    } else {
      Future.successful(())
    }
    for {
      _ <- push
      _ <- dao.saveFlights(request, flights)
    } yield ()
  }

  override def getFlights(request: FlightSearchRequest): Future[Option[FlightSearchResult]] = {
    dao.getFlights(request)
  }
}
