package ru.yandex.tours.storage.flight

import ru.yandex.tours.model.search.SearchResults.FlightSearchResult
import ru.yandex.tours.model.search.{FlightSearchRequest, SearchResults}
import ru.yandex.tours.storage.yt.entities.Flights
import ru.yandex.tours.util.lang.Futures._
import ru.yandex.travel.yt.YtDao

import scala.concurrent.{ExecutionContext, Future}

class YtFlightsDao(dao: YtDao[Flights])
                  (implicit ec: ExecutionContext) extends FlightsDao {
  override def saveFlights(request: FlightSearchRequest, flights: SearchResults.FlightSearchResult): Future[Unit] = {
    dao.put(new Flights(request.sessionId, flights.toByteArray)).asScalaFuture.toUnit
  }

  override def getFlights(request: FlightSearchRequest): Future[Option[SearchResults.FlightSearchResult]] = {
    val res = dao.get(request.sessionId).asScalaFuture
    for (of <- res) yield {
      for (f <- of.asOption) yield {
        FlightSearchResult.parseFrom(f.getFlights)
      }
    }
  }
}
