package ru.yandex.tours.storage.instrumented

import ru.yandex.tours.model.search.{HotelSearchRequest, OfferSearchRequest, SearchResults}
import ru.yandex.tours.storage.YtToursDao
import ru.yandex.tours.util.lang.Futures.RichFuture
import ru.yandex.tours.util.Metrics

import scala.concurrent.Future

trait InstrumentedYtByteArrayDao extends YtToursDao {
  private val metrics = Metrics(s"storage.ytdao.$tableName")
  private val saveHotelTimer = metrics.getTimer("save-hotels")
  private val saveOffersTimer = metrics.getTimer("save-offers")
  private val getHotelTimer = metrics.getTimer("get-hotel")
  private val getOfferTimer = metrics.getTimer("get-offer")
  private val getOffersTimer = metrics.getTimer("get-offers")
  private val getOffersBatchMeter = metrics.getMeter("get-offers-batch")


  override def saveHotelSearchResult(request: HotelSearchRequest,
                                     response: SearchResults.HotelSearchResult): Future[Unit] = {
    val ctx = saveHotelTimer.time()
    super.saveHotelSearchResult(request, response).withTimerContext(ctx)
  }

  override def getHotelSearchResultBytes(
                                          request: HotelSearchRequest): Future[Option[Array[Byte]]] = {
    val ctx = getHotelTimer.time()
    super.getHotelSearchResultBytes(request)
      .withTimerContext(ctx)
  }

  override def saveOffersSearchResult(request: OfferSearchRequest,
                                      response: SearchResults.OfferSearchResult): Future[Unit] = {
    val ctx = saveOffersTimer.time()
    super.saveOffersSearchResult(request, response)
      .withTimerContext(ctx)
  }

  override def getOffersSearchResultBytes(
                                           request: OfferSearchRequest): Future[Option[Array[Byte]]] = {
    val ctx = getOfferTimer.time()
    super.getOffersSearchResultBytes(request)
      .withTimerContext(ctx)
  }

  override def getOffersSearchResultsBytes(
                                            request: HotelSearchRequest,
                                            hotelIds: Iterable[Int]): Future[Seq[Array[Byte]]] = {
    val ctx = getOffersTimer.time()
    getOffersBatchMeter.mark(hotelIds.size)
    super.getOffersSearchResultsBytes(request, hotelIds)
      .withTimerContext(ctx)
  }
}
