package ru.yandex.tours.storage.minprice

import org.joda.time.LocalDate
import ru.yandex.tours.storage.minprice.MinPriceDao.PriceEntity

import scala.concurrent.Future

/* @author berkut@yandex-team.ru */

trait MinPriceDao {

  def update(prices: Iterable[PriceEntity]): Future[Unit]

  def getPrices(from: Int, to: Int, nights: Int, ages: Seq[Int], whenStart: LocalDate, whenEnd: LocalDate): Future[Iterable[PriceEntity]]

  def getPrices(from: Int, to: Int, nights: Seq[Int], ages: Seq[Int], whenStart: LocalDate, whenEnd: LocalDate): Future[Iterable[PriceEntity]]
}

object MinPriceDao {
  case class PriceEntity(from: Int, to: Int, nights: Int, ages: Seq[Int], when: LocalDate, operatorId: Int, price: Int)
}
