package ru.yandex.tours.storage.minprice
import org.joda.time.LocalDate
import ru.yandex.tours.storage.minprice.MinPriceDao.PriceEntity
import ru.yandex.tours.util.Logging

import scala.concurrent.{ExecutionContext, Future}

class MinPriceTwinDao(primary: MinPriceDao, secondary: MinPriceDao, sync: Boolean)
                     (implicit ec: ExecutionContext) extends MinPriceDao with Logging {
  override def update(prices: Iterable[MinPriceDao.PriceEntity]): Future[Unit] = {
    val p = primary.update(prices)
    val s = secondary.update(prices).recover({
      case e =>
        log.error("Error in Secondary Storage", e)})
    val ss = if (sync) s else Future.successful(())
    for {
      prim <- p
      _ <- ss
    } yield prim
  }

  override def getPrices(from: Int, to: Int, nights: Int, ages: Seq[Int],
                         whenStart: LocalDate, whenEnd: LocalDate): Future[Iterable[PriceEntity]] = {
    val p = primary.getPrices(from, to, nights, ages, whenStart, whenEnd)
    val s = secondary.getPrices(from, to, nights, ages, whenStart, whenEnd).recoverWith({
      case e =>
        log.error("Error in Secondary Storage", e)
        Future.successful(Iterable.empty)})
    val ss = if (sync) s else Future.successful(Iterable.empty)
    for {
      prim <- p
      _ <- ss
    } yield prim
  }

  override def getPrices(from: Int, to: Int, nights: Seq[Int], ages: Seq[Int],
                         whenStart: LocalDate, whenEnd: LocalDate): Future[Iterable[PriceEntity]] = {
    val p = primary.getPrices(from, to, nights, ages, whenStart, whenEnd)
    val s = secondary.getPrices(from, to, nights, ages, whenStart, whenEnd).recoverWith({
      case e =>
        log.error("Error in Secondary Storage", e)
        Future.successful(Iterable.empty)})
    val ss = if (sync) s else Future.successful(Iterable.empty)
    for {
      prim <- p
      _ <- ss
    } yield prim
  }

}
