package ru.yandex.tours.storage.serpcache

import ru.yandex.tours.model.search.SearchResults.{HotelSearchResult, OfferSearchResult, ResultInfo, SearchProgress}
import ru.yandex.tours.model.search.{HotelSearchRequest, OfferSearchRequest}
import ru.yandex.tours.storage.yt.entities.CacheItem
import ru.yandex.tours.util.{GZip, Logging}
import ru.yandex.tours.util.lang.Futures._
import ru.yandex.travel.yt.YtDao

import scala.collection.JavaConversions._
import scala.compat.java8.FutureConverters
import scala.concurrent.{ExecutionContext, Future}
import scala.util.{Failure, Success}

class SerpCacheDao(ytDaoList: Array[YtDao[CacheItem]])
                  (implicit ec: ExecutionContext) extends Logging {
  def saveHotelSearchResult(request: HotelSearchRequest, response: HotelSearchResult): Unit = {
    val item = new CacheItem(
      0, //Special Hotel Id
      request.when.toString(),
      request.nights,
      request.agesSerializable.mkString(","),
      GZip.compress(response.toByteArray),
      "hotelsSearch"
    )
    val futures = ytDaoList.map(dao => FutureConverters.toScala(dao.put(item)).toUnit)
    futures.foreach(f => f.onComplete {
      case Success(_) => log.debug("Saved hotel search result")
      case Failure(e) => log.error("Error in YT while saveHotelSearchResult", e)
    })
  }

  def saveOffersSearchResult(request: OfferSearchRequest, response: OfferSearchResult): Unit = {
    val item = new CacheItem(
      request.hotelId,
      request.hotelRequest.when.toString(),
      request.hotelRequest.nights,
      request.hotelRequest.agesSerializable.mkString(","),
      GZip.compress(response.toByteArray), "offersSearch")
    val futures = ytDaoList.map(dao => FutureConverters.toScala(dao.put(item)).toUnit)
    futures.foreach(f => f.onComplete {
        case Success(_) => log.debug("Saved offers search result")
        case Failure(e) => log.error("Error in YT while saveOffersSearchResult", e)
      })
  }
}
