package ru.yandex.tours.storage.subscriptions

import ru.yandex.tours.model.subscriptions.{Notification, Subscription, UserIdentity}

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 10.08.15
 */
trait NotificationStorage {
  def getLastNotification(subscription: Subscription): Future[Option[Notification]] = {
    getLastNotification(subscription.user, subscription.id)
  }

  def getLastNotification(user: UserIdentity, id: String): Future[Option[Notification]]

  def saveNotification(notification: Notification): Future[Unit]
}
