package ru.yandex.tours.storage.subscriptions

import ru.yandex.tours.model.subscriptions.{Notification, UserIdentity}
import ru.yandex.tours.util.Logging

import scala.concurrent.{ExecutionContext, Future}

class NotificationsTwinDao(primary: NotificationStorage, secondary: NotificationStorage, sync: Boolean)
                          (implicit ec: ExecutionContext) extends NotificationStorage with Logging{
  override def getLastNotification(user: UserIdentity, id: String): Future[Option[Notification]] = {
    val p = primary.getLastNotification(user, id)
    val s = secondary.getLastNotification(user, id).recoverWith({
      case e =>
        log.error("Error in secondary storage", e)
        Future.successful(Option.empty)}
    )
    val ss = if (sync) s else Future.successful(Option.empty)
    for {
      prim <- p
      _ <- ss
    } yield prim
  }

  override def saveNotification(notification: Notification): Future[Unit] = {
    val p = primary.saveNotification(notification)
    val s = secondary.saveNotification(notification).recover({
      case e =>
        log.error("Error in Secondary Storage", e)})
    val ss = if (sync) s else Future.successful(())
    for {
      prim <- p
      _ <- ss
    } yield prim
  }
}
