package ru.yandex.tours.storage.subscriptions

import ru.yandex.tours.model.subscriptions.{Subscription, UserIdentity}

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 10.08.15
 */
trait SubscriptionStorage {

  def getSubscription(user: UserIdentity, id: String): Future[Option[Subscription]]

  def getSubscriptions(user: UserIdentity): Future[Seq[Subscription]]

  def getAllSubscriptions: Future[Seq[Subscription]]

  def disableSubscription(user: UserIdentity, id: String): Future[Unit]
}
