package ru.yandex.tours.storage.subscriptions

import akka.util.Timeout
import ru.yandex.tours.app._
import ru.yandex.tours.storage.yt.entities.YtNotification

import scala.concurrent.duration._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 22.10.15
 */
trait SubscriptionsStorageSupport {
  this: Application with AkkaSupport with HttpSupport =>

  lazy val subscriptionStorage = new HttpSubscriptionStorage(
    httpClient,
    config.getString("tours.subscriptions.api.host"),
    config.getInt("tours.subscriptions.api.port")
  )(akkaSystem.dispatcher, Timeout(10.seconds))
}

trait NotificationStorageSupport {
  this: Application with AkkaSupport with YtSupport with CommonDataHolders =>

  lazy val notificationStorage: NotificationStorage = buildNotificationStorage

  private def buildNotificationStorage: NotificationStorage = {
    lazy val ytDao = new YtNotificationStorage(
      createYtDao(classOf[YtNotification], ytSettings.primaryCluster, ttl = 90.days.toMillis),
      hotelsIndex, tourOperators)(akkaSystem.dispatcher)
    ytDao
  }
}