package ru.yandex.tours.storage.subscriptions

import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.model.subscriptions.{Notification, Subscriptions, UserIdentity}
import ru.yandex.tours.operators.TourOperators
import ru.yandex.tours.storage.yt.entities.YtNotification
import ru.yandex.tours.subscriptions.model.ModelConverters._
import ru.yandex.tours.util.Logging
import ru.yandex.tours.util.lang.Futures._
import ru.yandex.travel.yt.YtDao

import scala.concurrent.{ExecutionContext, Future}

class YtNotificationStorage(dao: YtDao[YtNotification],
                            hotelsIndex: HotelsIndex,
                            tourOperators: TourOperators)
                           (implicit ec: ExecutionContext) extends NotificationStorage with Logging {
  override def getLastNotification(user: UserIdentity, id: String): Future[Option[Notification]] = {
    for (of <- dao.get(user.toString, id).asScalaFuture) yield {
      for (f <- of.asOption) yield {
        Subscriptions.Notification.parseFrom(f.getNotification).toModel(hotelsIndex, tourOperators)
      }
    }
  }

  override def saveNotification(notification: Notification): Future[Unit] = {
    dao.put(new YtNotification(notification.subscription.user.toString, notification.subscription.id,
      notification.toProto.toByteArray)).asScalaFuture.toUnit
  }
}
