package ru.yandex.tours.storage.transfer

import ru.yandex.tours.model.search.SearchResults.TransferSearchResult
import ru.yandex.tours.model.search.TransferSearchRequest
import ru.yandex.tours.util.Logging

import scala.concurrent.{ExecutionContext, Future}

class TransfersTwinDao(primary: TransferDao, secondary: TransferDao, sync: Boolean)
                      (implicit ec: ExecutionContext) extends TransferDao with Logging {
  override def saveTransfers(request: TransferSearchRequest, transfers: TransferSearchResult): Future[Unit] = {
    val p = primary.saveTransfers(request, transfers)
    val s = secondary.saveTransfers(request, transfers).recover({
      case e =>
        log.error("Error in Secondary Storage", e)})
    val ss = if (sync) s else Future.successful(())
    for {
      prim <- p
      _ <- ss
    } yield prim
  }

  override def getTransfers(request: TransferSearchRequest): Future[Option[TransferSearchResult]] = {
    val p = primary.getTransfers(request)
    val s = secondary.getTransfers(request).recoverWith({
      case e =>
        log.error("Error in Secondary Storage", e)
        Future.successful(Option.empty)})
    val ss = if (sync) s else Future.successful(Option.empty)
    for {
      prim <- p
      _ <- ss
    } yield prim
  }
}
