package ru.yandex.tours.storage.transfer

import ru.yandex.tours.model.search.SearchResults.TransferSearchResult
import ru.yandex.tours.model.search.TransferSearchRequest
import ru.yandex.tours.storage.yt.entities.Transfers
import ru.yandex.tours.util.lang.Futures._
import ru.yandex.travel.yt.YtDao

import scala.concurrent.{ExecutionContext, Future}

class YtTransferDao(dao: YtDao[Transfers])
                   (implicit ec: ExecutionContext) extends TransferDao {

  override def saveTransfers(request: TransferSearchRequest, transfers: TransferSearchResult): Future[Unit] = {
    dao.put(new Transfers(request.sessionId, transfers.toByteArray)).asScalaFuture.toUnit
  }

  override def getTransfers(request: TransferSearchRequest): Future[Option[TransferSearchResult]] = {
    for (otsr <- dao.get(request.sessionId).asScalaFuture) yield {
      for (tsr <- otsr.asOption) yield {
        TransferSearchResult.parseFrom(tsr.getTransfers)
      }
    }
  }
}
