package ru.yandex.tours.storage.users

import ru.yandex.tours.model.UserVisits.{PriceData, Record}
import ru.yandex.tours.model.search.HotelSearchRequest

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 02.06.16
 */
trait FavoritesDao {

  def getAll(uid: Long): Future[Seq[Record]]

  def getHotels(uid: Long, hotelIds: Seq[Int]): Future[Seq[Record]]

  def delete(uid: Long, hotelId: Int): Future[Unit]

  def newRecord(uid: Long, hotelId: Int, request: HotelSearchRequest, data: PriceData): Future[Unit]
}
