package ru.yandex.tours.storage.yt.entities;

import ru.yandex.travel.yt.mappings.YtColumn;
import ru.yandex.travel.yt.mappings.YtTable;
import ru.yandex.yt.ytclient.tables.ColumnValueType;


@YtTable(tableName = "cache", ttl = 1200000L, timestampColumn = "Timestamp")
public class CacheItem {
    @YtColumn()
    private int HotelId;

    @YtColumn()
    private String Date;

    @YtColumn()
    private int Nights;

    @YtColumn()
    private String Ages;

    @YtColumn()
    private String Source;

    @YtColumn()
    private long Timestamp;

    @YtColumn()
    private byte[] SearchRes;

    public CacheItem(int hotelId, String date, int nights, String ages, byte[] searchRes, String source) {
        HotelId = hotelId;
        Date = date;
        Nights = nights;
        Ages = ages;
        Timestamp = System.currentTimeMillis();
        SearchRes = searchRes;
        Source = source;
    }

    public CacheItem() {
    }

    public int getHotelId() {
        return HotelId;
    }

    public String getDate() {
        return Date;
    }

    public int getNights() {
        return Nights;
    }

    public String getAges() {
        return Ages;
    }

    public long getTimestamp() {
        return Timestamp;
    }

    public byte[] getSearchRes() {
        return SearchRes;
    }

    public String getSource() {
        return Source;
    }
}
