package ru.yandex.tours.storage.yt.entities;

import ru.yandex.travel.yt.mappings.YtColumn;
import ru.yandex.travel.yt.mappings.YtTable;
import ru.yandex.yt.ytclient.tables.ColumnValueType;

@YtTable(timestampColumn = "WriteTime")
public class DirectionPrice {
    @YtColumn()
    private int From;

    @YtColumn()
    private String Ages;

    @YtColumn()
    private int Month;

    @YtColumn()
    private int GeoId;

    @YtColumn()
    private byte[] BestPrice;

    @YtColumn()
    private long WriteTime;

    public DirectionPrice(int from, String ages, int month, int geoId, byte[] bestPrice) {
        From = from;
        Ages = ages;
        Month = month;
        GeoId = geoId;
        BestPrice = bestPrice;
        WriteTime = System.currentTimeMillis();
    }

    public DirectionPrice() {
    }

    public int getFrom() {
        return From;
    }

    public String getAges() {
        return Ages;
    }

    public int getMonth() {
        return Month;
    }

    public int getGeoId() {
        return GeoId;
    }

    public byte[] getBestPrice() {
        return BestPrice;
    }

    public long getWriteTime() {
        return WriteTime;
    }
}
