package ru.yandex.tours.storage.yt.entities;

import ru.yandex.travel.yt.mappings.YtColumn;
import ru.yandex.travel.yt.mappings.YtTable;
import ru.yandex.yt.ytclient.tables.ColumnValueType;

@YtTable(timestampColumn = "Timestamp")
public class Price {
    @YtColumn()
    private int From;

    @YtColumn()
    private int To;

    @YtColumn()
    private int Nights;

    @YtColumn()
    private String Ages;

    @YtColumn()
    private long When;

    @YtColumn()
    private int Operator;

    @YtColumn()
    private int MinPrice;

    public Price() {
    }

    public Price(int from, int to, int nights, String ages, long when, int operator, int minPrice) {
        From = from;
        To = to;
        Nights = nights;
        Ages = ages;
        When = when;
        Operator = operator;
        MinPrice = minPrice;
    }


    public int getFrom() {
        return From;
    }

    public int getTo() {
        return To;
    }

    public int getNights() {
        return Nights;
    }

    public String getAges() {
        return Ages;
    }

    public long getWhen() {
        return When;
    }

    public int getOperator() {
        return Operator;
    }

    public int getMinPrice() {
        return MinPrice;
    }
}


