package ru.yandex.tours.tools

import java.io.{FileInputStream, FileOutputStream}

import ru.yandex.tours.indexer.suggest.AgencyCitySuggestGenerator
import ru.yandex.tours.model.Agencies.ProtoAgency
import ru.yandex.tours.model.Agency
import ru.yandex.tours.util.ProtoIO

import scala.util.Try

object AgencyCitiesSuggestPreparer extends Tool {
  val os = new FileOutputStream("agency_cities_suggest")
  val protoAgencies = ProtoIO.loadFromStream(new FileInputStream("tours-data/data/agencies.proto"), ProtoAgency.PARSER).toVector
  val agencies = protoAgencies.flatMap(proto => Try(Agency.parseAgency(proto)).toOption)
  AgencyCitySuggestGenerator.generate(agencies, tree, os)
}
