package ru.yandex.tours.tools

import java.io.{File, FileInputStream, FileOutputStream}

import ru.yandex.tours.model.Agencies.ProtoAgency
import ru.yandex.tours.util.parsing.{LongValue, Tabbed}
import ru.yandex.tours.util.{IO, ProtoIO}

import scala.collection.JavaConversions._
import scala.io.Source

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 08.05.15
 */
object AgencyPhonesTool extends App {

  val replaces = Source.fromFile("/Users/darl/phones.txt").getLines().drop(1).map {
    case Tabbed(LongValue(id), _, _, _, newPhone) => id -> newPhone
  }.toMap

  replaces.foreach(println)

  val in = new File("tours-data/data/agencies.proto")
  val out = new File("./agencies.proto")
  IO.using(
    new FileInputStream(in),
    new FileOutputStream(out)
  ) { (in, out) =>
    val protoAgencies = ProtoIO.loadFromStream(in, ProtoAgency.PARSER)
    for (agency <- protoAgencies) {
      val builder = agency.toBuilder
      for (newPhone <- replaces.get(agency.getId)) {
        val oldPhones = agency.getPhonesList
        val oldShows = agency.getShows
        builder
          .clearPhones()
          .addPhones(newPhone)
          .setShows(oldShows + 1000000)
        println(s"Replaced old phones [${oldPhones.mkString(",")}] to [$newPhone] shows = $oldShows")
      }
      builder.build.writeDelimitedTo(out)
    }
  }

}
