package ru.yandex.tours.tools

import java.io.File

import ru.yandex.tours.hotels.HotelIO
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.util.collections.Bag

import scala.collection.JavaConversions._
import scala.collection.mutable

object CheckMerging extends App {
  private def hotelIterator = HotelIO.loadFromFileAsIterator(new File("hotels.proto"))

  val bag = new Bag[Partner]()
  hotelIterator.flatMap(hotel => hotel :: hotel.getChildrenList.toList).foreach { hotel =>
    bag += Partners(hotel.getPartnerId)
  }
  val knownIds = mutable.HashSet.empty[(Partner, String)]
  hotelIterator.flatMap(hotel => hotel :: hotel.getChildrenList.toList).foreach { hotel =>
    val partnerId = (Partners(hotel.getPartnerId), hotel.getLocalId)
    if (knownIds.contains(partnerId)) {
      println(s"Hotel is already known: $partnerId")
    } else {
      knownIds += partnerId
    }

  }
  println(bag.toMap)
  println("Total size: " + hotelIterator.size)
}
