package ru.yandex.tours.tools

import java.io.PrintWriter

import ru.yandex.tours.geo.base.Region
import ru.yandex.tours.model.Languages
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

import scala.collection.mutable

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 05.06.15
 */
object DeparturesConverter extends Tool {
  def name(region: Region) = region.name(Languages.ru)
  // rid -> ((from, to) -> count)
  val map = new mutable.HashMap[Int, mutable.HashMap[(Int, Int), Int]]()

  val regionMap = tree.regions.map(r => name(r) -> r.id).toMap

  scala.io.Source.fromFile("departure_stats.txt").getLines().drop(1).foreach {
    case Tabbed(_, _, ridStr, fromStr, toStr, cityStr, countryStr, _, _) =>
      val from = regionMap(fromStr)
      val rid = regionMap(ridStr)
      val to = regionMap(countryStr)

      val m2 = map.getOrElseUpdate(rid, new mutable.HashMap)

      m2 += (from, to) -> (m2.getOrElse((from, to), 0) + 1)
  }

  val names = tree.regions.map(r => r.id -> name(r)).toMap

  IO.using(new PrintWriter("departure_stats.tsv")) { out =>
    for ((rid, values) <- map if tree.pathToRoot(rid).exists(_.id == 225)) {
      val sorted = values.toVector.sortBy(-_._2)
      val sum = sorted.map(_._2).sum

      if (sum > 10) {
        println(names(rid) + " (" + tree.pathToRoot(rid).drop(1).takeWhile(_.id != 225).map(name).mkString(" -> ") + ")")
        val byCountry = sorted.map(s => (s._1._1, s._1._2, s._2)).groupBy(_._2)
        val total = sorted.map(s => (s._1._1, s._2)).groupBy(_._1).mapValues(_.map(_._2).sum).toVector

        for ((from, count) <- total.sortBy(-_._2)) {
          println(s"  из ${names(from)} – $count")
        }
        println("")

        for ((country, seq) <- byCountry) {
          println(s"  в ${names(country)}")

          for ((from, _, count) <- seq.sortBy(-_._3)) {
            println(s"    из ${names(from)} – $count")
            out.println(Tabbed(rid, from, country, count))
          }
        }
        println("============")
      }
    }
  }
}
