package ru.yandex.tours.tools

import java.io.PrintWriter

import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

object EgyptFilterTool extends Tool {

  def filterBase(name: String): Unit = {
    val pw = new PrintWriter(s"${name}_without_egypt.tsv")
    scala.io.Source.fromFile(s"tours-data/data/$name.tsv").getLines().filterNot {
      case Tabbed(IntValue(partnerId), IntValue(geoId), _) =>
        Partners.isToursPartner(Partners(partnerId)) && tree.pathToRoot(geoId).exists(_.id == 1056)
    }.foreach(pw.println)
    pw.close()
  }

  filterBase("cities")
  filterBase("countries")
}
