package ru.yandex.tours.tools

import java.io.{FileOutputStream, File}

import ru.yandex.tours.hotels.HotelIO
import scala.collection.JavaConversions._

object ExcessPhotoCleaner extends App {
  val cleared = HotelIO.loadFromFileAsIterator(new File("ided_hotels.proto")).map { hotel =>
    val builder = hotel.toBuilder
    val children = hotel.getChildrenList.map(_.toBuilder.clearPhotos().clearImages().build)
    builder.clearChildren().addAllChildren(children).build
  }
  val os = new FileOutputStream("cleaned.hotels.proto")
  cleared.foreach(_.writeDelimitedTo(os))
  os.close()
}
