package ru.yandex.tours.tools

import ru.yandex.tours.model.Languages
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

object ExportForPartnersTool extends Tool {
  val partner = Partners.hotels101
  IO.printFile(s"hotels_for_$partner.tsv") { pw =>
    pw.println(Tabbed("id", "url", "name", "stars", "longitude", "latitude", "region_id", "country_id", s"${partner}_ids", s"${partner}_urls"))
    shardedHotelsIndex.hotels.foreach { hotel =>
      val country = tree.country(hotel.geoId).get.id
      val partnerInfo = hotel.partnerIds.filter(_.partner == partner)
      val partnerIds = partnerInfo.map(_.id).mkString("##")
      val partnerUrls = partnerInfo.map(_.url).mkString("##")
      pw.println(Tabbed(hotel.id, s"https://travel.yandex.ru/hotel/${hotel.id}", hotel.name(Languages.ru), hotel.star.id, hotel.longitude, hotel.latitude, hotel.geoId, country, partnerIds, partnerUrls))
    }
  }
  IO.printFile(s"regions_for_$partner.tsv") { pw =>
    pw.println(Tabbed("id", "parent_id", "name"))
    tree.regions.foreach { region =>
      pw.println(Tabbed(region.id, region.parentId, region.name(Languages.ru)))
    }
  }
}
