package ru.yandex.tours.tools

import java.io.{File, FileInputStream, PrintWriter}

import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

object GeoMappingTool extends Tool {

  case class Mapping(geoId: Int,
                     ltId: Seq[String],
                     sunmarId: Seq[String],
                     ostrovokId: Seq[String],
                     bookingId: Seq[String],
                     oktogoId: Seq[String],
                     hotels101Id: Seq[String],
                     newLtId: Seq[String],
                     sodisId: Seq[String]) {
    def +(m: Mapping) = copy(geoId, ltId ++ m.ltId, sunmarId ++ m.sunmarId)
  }

  private def toSeq(x: String) = Seq(x).filter(_.nonEmpty)

  def readGeoMapping(file: File) = {
    IO.readLines(new FileInputStream(file)).collect {
      case Tabbed(IntValue(geoId), parts @_*) =>
        val ltId = parts(2)
        val pegasId = parts(5)
        val bgId = parts(8)
        val sletatId = parts(11)
        val innaId = parts(14)
        val sunmarId = parts(17)
        val bookingId = parts(20)
        val ostrovokId = parts(23)
        val oktogoId = parts(26)
        val hotels101 = parts(29)
        val newLtId = parts(32)
        val sodisId = parts(35)
        Mapping(geoId, toSeq(ltId), toSeq(sunmarId), toSeq(ostrovokId), toSeq(bookingId), toSeq(oktogoId), toSeq(hotels101), toSeq(newLtId), toSeq(sodisId))
    }
  }

  def convert(from: Seq[String], to: String) {
    val partner2geoId = from.flatMap(f => readGeoMapping(new File(f)))
    val pw = new PrintWriter(to)
    partner2geoId.toVector
      .groupBy(_.geoId).mapValues(_.reduce(_ + _))
      .values.toVector
      .sortBy(_.geoId.toString).foreach { x =>
      if (x.ltId.nonEmpty) {
        val id =
          if (x.ltId.size == 1) x.ltId.head
          else ??? // x.ltId.maxBy { id => println(x); ??? } //TODO
        pw.println(Partners.lt.id + "\t" + x.geoId + "\t" + id)
      }
      x.sunmarId.foreach(id => pw.println(Partners.sunmar.id + "\t" + x.geoId + "\t" + id))
      x.ostrovokId.foreach(id => pw.println(Partners.ostrovok.id + "\t" + x.geoId + "\t" + id))
      x.bookingId.foreach(id => pw.println(Partners.booking.id + "\t" + x.geoId + "\t" + id))
    }
    pw.close()
  }

  convert(Seq("util-heavy/python/geo/data/matchingresults/geo2AllPartners.countries.tsv"), "tours-data/data/countries.tsv")
 /* convert(
    Seq(
      "util-heavy/python/geo/data/matchingresults/geo2AllPartners.resorts.tsv",
      "util-heavy/python/geo/data/matchingresults/geo2AllPartners.resorts.dups.tsv"
    ),
    "tours-data/data/cities.tsv"
  )*/
}
