package ru.yandex.tours.tools

import java.io.File

import com.yandex.yoctodb.immutable.Database
import org.springframework.util.ReflectionUtils
import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.extdata.provider.cache.LocalFSDataCache
import ru.yandex.extdata.provider.{HttpExtDataClient, RemoteExtDataService}
import ru.yandex.tours.extdata.{DataTypes, ExtDataUpdateChecker}
import ru.yandex.tours.hotels.{HotelIO, ShardedYoctoHotelsIndex}
import ru.yandex.tours.model.hotels.HotelsHolder
import ru.yandex.tours.testkit.TestData

trait HotelAware extends TestData {
  private lazy val extDataClient = new HttpExtDataClient("http://indexer-old-01-sas.test.vertis.yandex.net:36445", 4, 10000)
  private lazy val localFSCache = {
    new File("tours-data/cache").mkdirs()
    val cache = new LocalFSDataCache(
      DataTypes.registry,
      extDataClient,
      "tours-data/cache",
      false
    )
    cache.afterPropertiesSet()
    cache
  }

  lazy val extDataService: ExtDataService = new RemoteExtDataService(localFSCache)

  lazy val shardedHotelsIndex = ShardedYoctoHotelsIndex.fromExtData(
    new File("tours-data/hotels_index"),
    data.hotelRatings,
    extDataService,
    ExtDataUpdateChecker.empty,
    lazyLoadResources = false
  )

  def shardedHotels: Iterator[HotelsHolder.TravelHotel] = {
    val method = ReflectionUtils.findMethod(shardedHotelsIndex.getClass, "db")
    ReflectionUtils.makeAccessible(method)
    val db = ReflectionUtils.invokeMethod(method, shardedHotelsIndex).asInstanceOf[Database]
    (0 until db.getDocumentCount).iterator.map { doc =>
      val buffer = db.getDocument(doc)
      HotelsHolder.TravelHotel.parseFrom(buffer.toByteArray)
    }
  }
  
  def hotels(path: String): Iterator[HotelsHolder.Hotel] = {
    HotelIO.loadFromFileAsIterator(path)
  }
}
