package ru.yandex.tours.tools

import java.io.File

import ru.yandex.tours.app.{AkkaSupport, Application, DefaultEnvironment, DefaultHttpSupport}
import ru.yandex.tours.db.tables.Clusterization
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.testkit.TestData
import ru.yandex.tours.util.collections.RafBasedMap
import ru.yandex.tours.util.parsing.Tabbed
import ru.yandex.tours.util.{IO, ProtoIO}

import scala.collection.JavaConverters._
import scala.collection.mutable

object Hotels101MergeTool extends TestData with HotelAware with Application with DefaultEnvironment with AkkaSupport with DefaultHttpSupport with TestDb {
  implicit val ec = akkaSystem.dispatcher
  val hotelFileName = "partner_hotels.proto"
  //  val dao = new HotelsDao(prodDb)
  //  IO.usingAsync(new FileOutputStream(hotelFileName)) { os =>
  //    dao.retrieveRafMap().map(_.valuesIterator.foreach(_.writeDelimitedTo(os)))
  //  }.onComplete(println)

  val transactionId = 229
  def hotels = ProtoIO.loadFromFile(new File(hotelFileName), PartnerHotel.PARSER)
  val rafMap = new RafBasedMap[Int, PartnerHotel](_.toByteArray, PartnerHotel.parseFrom)
  hotels.foreach(h => rafMap += h.getId -> h)
  val addedIds = mutable.Buffer.empty[Int]
  Clusterization.retrieveClusterLinks(0.5, prodDb, "Tool").map { links =>
    val set = links.map(link => link.child -> link.parent).toSet
    IO.printFile("101hotels_clustering.sql") { sqlPw =>
      IO.printFile("101hotels_merge.tsv") { mergePw =>
        IO.printFile("101hotels_head.tsv") { headPw =>
          for (h <- hotels.filter(_.getRawHotel.getPartner == Partners.hotels101.id)) {
            h.getRawHotel.getAddInfoList.asScala.find(_.getName == "YandexID") match {
              case Some(ai) =>
                val hotels101 = ai.getValue.toInt
                val our = h.getId
                val from = Math.min(hotels101, our)
                val to = Math.max(hotels101, our)
                if (!set.contains((from, to))) {
                  rafMap.get(hotels101) match {
                    case Some(master) =>
                      val distance: Double = ru.yandex.tours.geo.distanceInKm(h.getRawHotel.getPoint, master.getRawHotel.getPoint)
                      if (!h.getRawHotel.hasPoint || !master.getRawHotel.hasPoint || distance < 100) {
                        addedIds += hotels101
                        val sql = s"insert into clusterization (parent, child, transaction_id, confidence, link_type) values ($our,$hotels101, $transactionId, 0.7, 0);"
                        sqlPw.println(sql)
                      } else {
                        println(Tabbed(h.getRawHotel.getPartnerUrl, h.getRawHotel.getPartnerId, h.getId, hotels101, s"https://travel.yandex.ru/hotel/$hotels101"))
                      }
                    case None =>
                      println(s"Can not find hotel by id: $hotels101")
                  }

                  mergePw.println(s"http://travel-admin.vertis.yandex-team.ru/hotels/compare/${ai.getValue}/${h.getId}")
                }
              case None => headPw.println(s"http://travel-admin.vertis.yandex-team.ru/hotels/partner/${h.getId}")
            }
          }
        }
      }
    }
    IO.printFile("set_is_new.sql") { pw =>
      pw.println(s"UPDATE hotels SET is_new = false WHERE id in (${addedIds.mkString(", ")});")
    }
    rafMap.close()
  }.onComplete(println)

}
