package ru.yandex.tours.tools

import java.io.{File, PrintWriter}

import ru.yandex.tours.hotels.HotelIO
import ru.yandex.tours.model.hotels.Partners
import scala.collection.JavaConversions._

object IdUrlExporter extends App {
  val pw = new PrintWriter("id_to_url.tsv")
  HotelIO.loadFromFileAsIterator(new File("ided_hotels.proto")).foreach { hotel =>
    val mainId = hotel.getId
    (hotel :: hotel.getChildrenList.toList).foreach { partner =>
      pw.println(Seq(mainId, Partners(partner.getPartnerId), partner.getLocalId, partner.getPartnerUrl).mkString("\t"))
    }
  }
  pw.close()
}
