package ru.yandex.tours.tools

import java.io.PrintWriter
import java.net.URLEncoder

import akka.actor.ActorSystem
import org.json.JSONObject
import ru.yandex.tours.model.Image
import ru.yandex.tours.util.http.NingHttpClient
import spray.http.StatusCodes

import scala.concurrent.duration._
import scala.util.{Failure, Success}

object ImageDownloader extends App {
  val as = ActorSystem()
  implicit val ec = as.dispatcher
  val httpClient = new NingHttpClient(None)(as.dispatcher)
  val pw = new PrintWriter("avatar.images.list")
  val failed = new PrintWriter("avatar.failed.list")

  scala.io.Source.fromFile("photos.list").getLines().foreach(url => {
    val avatarUrl = s"http://indexer01f.vs.yandex.net:36445/put-tours/${Image.name(url)}?url=${URLEncoder.encode(url, "UTF-8")}"
    val future = httpClient.get(avatarUrl)(24.hours)
    future onComplete {
      case Success((StatusCodes.OK, entity)) =>
        val group = new JSONObject(entity).getInt("group-id")
        pw.println(Seq(url, group).mkString("\t"))
        pw.flush()
      case Success((sc, entity)) =>
        failed.println(url + "\t" + sc)
        failed.flush()
      case Failure(e) =>
        failed.println(url + "\t" + e.getMessage)
        failed.flush()
    }
  })
}
