package ru.yandex.tours.tools

import java.io.File

import ru.yandex.tours.model.BaseModel.ProtoImage
import ru.yandex.tours.model.image.ImageProviders.ImageProvider
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

object ImageParser {
  def parse(source: File, provider: ImageProvider) = {
    scala.io.Source.fromFile(source).getLines().collect {
      case Tabbed(url, _, IntValue(group), md5) =>
        url -> ProtoImage.newBuilder()
          .setGroup(group)
          .setName(md5)
          .setHost("//avatars.mds.yandex.net")
          .setProviderId(provider.id)
          .build()
    }.toMap
  }
}
